/*
 * Decompiled with CFR 0.152.
 */
package custom;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class LQSound {
    public static boolean SOUND_ON = true;
    private String[] snd_content = null;
    private int[][] total_sound = null;
    private boolean[] resume = null;
    public static final int TYPE_MIDI = 0;
    public static final int TYPE_AMR = 1;
    public static final int TYPE_MMF = 2;
    public static final int TYPE_WAV = 3;
    private static final String[] TYPE_CONTENT = new String[]{"audio/midi", "audio/amr", "audio/mmf", "audio/x-wav"};
    public Player[] m_multisound = null;
    public Player m_singlesound = null;
    public boolean IsSinglePlayer = false;
    public int m_cursoundID = -1;
    public int m_curLoop = -1;
    static int Volume = 100;

    public LQSound(String[] content, int[][] total, boolean[] needresume, boolean single) {
        this.snd_content = content;
        this.total_sound = total;
        this.resume = needresume;
        this.IsSinglePlayer = single;
        if (!this.IsSinglePlayer) {
            this.LoadSounds();
        }
    }

    private void LoadSounds() {
        try {
            this.m_multisound = new Player[this.total_sound.length];
            for (int i = 0; i < this.total_sound.length; ++i) {
                this.CreatePlayer(this.total_sound[i][0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void CreatePlayer(int id) {
        try {
            if (this.total_sound[id][2] == 1) {
                return;
            }
            InputStream is = null;
            is = this.getClass().getResourceAsStream(this.snd_content[this.total_sound[id][0]]);
            if (is == null) {
                return;
            }
            if (!this.IsSinglePlayer) {
                if (this.m_multisound[id] == null) {
                    this.m_multisound[id] = Manager.createPlayer((InputStream)is, (String)TYPE_CONTENT[this.total_sound[id][1]]);
                }
                this.m_multisound[id].realize();
                this.m_multisound[id].prefetch();
            } else {
                if (this.m_singlesound == null) {
                    this.m_singlesound = Manager.createPlayer((InputStream)is, (String)TYPE_CONTENT[this.total_sound[id][1]]);
                }
                this.m_singlesound.realize();
                this.m_singlesound.prefetch();
            }
            is.close();
            is = null;
            System.gc();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    Player curSound() {
        if (this.m_cursoundID == -1) {
            return null;
        }
        if (this.IsSinglePlayer) {
            return this.m_singlesound;
        }
        return this.m_multisound[this.m_cursoundID];
    }

    public void setVolume(int v) {
        Volume = v;
        Player p = this.curSound();
        if (null != p) {
            VolumeControl vc = (VolumeControl)p.getControl("VolumeControl");
            vc.setLevel(v);
        }
    }

    public void CreatePlayer(int id, String name) {
        try {
            if (this.total_sound[id][2] == 1) {
                return;
            }
            InputStream is = null;
            is = this.getClass().getResourceAsStream("/res/sound/" + name);
            if (is == null) {
                return;
            }
            if (!this.IsSinglePlayer) {
                if (this.m_multisound[id] != null) {
                    this.m_multisound[id].close();
                    this.m_multisound[id] = null;
                }
                this.m_multisound[id] = Manager.createPlayer((InputStream)is, (String)TYPE_CONTENT[this.total_sound[id][1]]);
                this.m_multisound[id].realize();
                this.m_multisound[id].prefetch();
                VolumeControl vc = (VolumeControl)this.m_multisound[id].getControl("VolumeControl");
                vc.setLevel(Volume);
            } else {
                this.m_singlesound = Manager.createPlayer((InputStream)is, (String)TYPE_CONTENT[this.total_sound[id][1]]);
                this.m_singlesound.realize();
                this.m_singlesound.prefetch();
                VolumeControl vc = (VolumeControl)this.m_singlesound.getControl("VolumeControl");
                vc.setLevel(Volume);
            }
            is.close();
            is = null;
            System.gc();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int GetPlayState() {
        if (!this.IsSinglePlayer) {
            if (this.m_cursoundID != -1) {
                return this.m_multisound[this.m_cursoundID].getState();
            }
            return 0;
        }
        if (this.m_singlesound == null) {
            return 0;
        }
        return this.m_singlesound.getState();
    }

    public void PlaySound(int id, int loop) {
        try {
            if (!SOUND_ON) {
                return;
            }
            if (id == -1) {
                return;
            }
            if (this.total_sound[id][2] == 1) {
                return;
            }
            if (!this.IsSinglePlayer) {
                if (this.m_multisound[id] == null) {
                    return;
                }
                if (id != this.m_cursoundID && this.m_cursoundID != -1) {
                    this.StopSound(this.m_cursoundID);
                }
                Player cfr_ignored_0 = this.m_multisound[id];
                if (this.m_multisound[id].getState() != 400) {
                    this.m_multisound[id].prefetch();
                    this.m_multisound[id].setLoopCount(loop);
                    this.m_multisound[id].start();
                }
            } else {
                if (this.m_singlesound == null) {
                    this.CreatePlayer(id);
                } else if (id != this.m_cursoundID && this.m_cursoundID != -1) {
                    this.ChangePlayer(id);
                }
                if (this.m_singlesound.getState() != 400) {
                    this.m_singlesound.prefetch();
                    if (this.m_singlesound.getMediaTime() != 0L) {
                        this.m_singlesound.setMediaTime(0L);
                    }
                    this.m_singlesound.setLoopCount(loop);
                    this.m_singlesound.start();
                }
            }
            this.m_cursoundID = id;
            this.m_curLoop = loop;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void StopCurrentSound() {
        this.StopSound(this.m_cursoundID);
    }

    public void StopSound(int id) {
        try {
            if (id == -1) {
                return;
            }
            if (this.total_sound[id][2] == 1) {
                return;
            }
            if (this.IsSinglePlayer) {
                if (this.m_singlesound == null) {
                    return;
                }
                if (this.m_singlesound.getState() == 400) {
                    this.m_singlesound.stop();
                    this.m_singlesound.setMediaTime(0L);
                    this.m_singlesound.close();
                    this.m_singlesound = null;
                }
            } else {
                if (this.m_multisound == null) {
                    return;
                }
                if (this.m_multisound[id] == null) {
                    return;
                }
                Player cfr_ignored_0 = this.m_multisound[id];
                if (this.m_multisound[id].getState() == 400) {
                    this.m_multisound[id].stop();
                    this.m_multisound[id].setMediaTime(0L);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void ChangePlayer(int id) {
        try {
            this.ReleaseSound(id);
            this.CreatePlayer(id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void SwitchControl() {
        this.SetSwitchStatus(!SOUND_ON);
        if (!SOUND_ON) {
            this.StopCurrentSound();
        } else {
            this.PlaySound(this.m_cursoundID, this.m_curLoop);
        }
    }

    public void SetSwitchStatus(boolean flag) {
        SOUND_ON = flag;
    }

    public boolean GetSwitchStatus() {
        return SOUND_ON;
    }

    private void ReleaseSound(int id) {
        block6: {
            try {
                this.StopSound(id);
                if (this.IsSinglePlayer) {
                    if (this.m_singlesound != null) {
                        this.m_singlesound.deallocate();
                        this.m_singlesound.close();
                        this.m_singlesound = null;
                    }
                    break block6;
                }
                if (this.m_multisound[id] == null) break block6;
                try {
                    this.m_multisound[id].deallocate();
                }
                catch (Exception ex1) {
                    // empty catch block
                }
                this.m_multisound[id].close();
                this.m_multisound[id] = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void ReleaseAllSounds() {
        if (this.IsSinglePlayer) {
            return;
        }
        for (int i = 0; i < this.total_sound.length; ++i) {
            this.ReleaseSound(i);
        }
    }

    public void Close() {
        if (this.IsSinglePlayer) {
            this.ReleaseSound(0);
        } else {
            this.ReleaseAllSounds();
        }
        System.gc();
    }

    public void Suspend() {
        this.StopCurrentSound();
    }

    public void Resume() {
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.m_cursoundID != -1 && this.resume[this.m_cursoundID]) {
            this.PlaySound(this.m_cursoundID, this.m_curLoop);
        }
    }
}

