/*
 * Decompiled with CFR 0.152.
 */
package custom;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import custom.Main;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Animation {
    static final byte DATA_IN_BYTE = 1;
    static final byte DATA_IN_SHORT = 2;
    static final int EXTEND_PER_ACTION = 2;
    static final int EXTEND_PER_MODULE = 4;
    static final int EXTEND_PER_SPRITE = 5;
    static final int EXTEND_PER_MECHMODULE = 7;
    static final int EXTEND_PER_COLACTBOX = 4;
    static final int EXTEND_PER_COLBOX = 4;
    String[] m_imageID;
    String[] m_plteID;
    boolean[] m_visible;
    short[][] m_modules;
    short[][] m_actions;
    byte[] m_nFrames;
    byte[] m_mechModels;
    short[][] m_frames;
    byte[] m_colBox;
    short[] m_attBox;
    byte[] m_bodyBox;
    private static byte[] smallbuf = new byte[4];
    static int width;
    static int height;
    static int x;
    static int y;
    private static Hashtable m_images;

    public void loadAnimation(InputStream is) throws Exception {
        int num;
        int j;
        int i;
        is.skip(6L);
        int count = Animation.readUnsignedByte(is);
        this.m_imageID = new String[count];
        this.m_plteID = new String[count];
        this.m_visible = new boolean[count];
        this.m_modules = new short[count][];
        for (i = 0; i < count; ++i) {
            this.m_imageID[i] = Animation.readUTF(is);
            this.m_plteID[i] = "";
            this.m_visible[i] = true;
            int size = Animation.readUnsignedShort(is);
            this.m_modules[i] = new short[size * 4];
            for (j = 0; j < size; ++j) {
                this.m_modules[i][j * 4 + 0] = (short)Animation.readUnsignedShort(is);
                this.m_modules[i][j * 4 + 1] = (short)Animation.readUnsignedShort(is);
                this.m_modules[i][j * 4 + 2] = (short)Animation.readUnsignedShort(is);
                this.m_modules[i][j * 4 + 3] = (short)Animation.readUnsignedShort(is);
            }
        }
        count = Animation.readUnsignedShort(is);
        this.m_colBox = new byte[count * 4];
        this.m_attBox = new short[count * 4];
        this.m_bodyBox = new byte[count * 4];
        this.m_frames = new short[count][];
        for (i = 0; i < count; ++i) {
            num = Animation.readUnsignedByte(is);
            this.m_frames[i] = new short[num * 5];
            for (int temp = 0; temp < num * 5; ++temp) {
                this.m_frames[i][temp] = (short)Animation.readUnsignedShort(is);
            }
            Animation.readFully(is, this.m_colBox, i << 2, 4);
            for (j = 0; j < 4; ++j) {
                this.m_attBox[(i << 2) + j] = (short)Animation.readUnsignedShort(is);
            }
            Animation.readFully(is, this.m_bodyBox, i << 2, 4);
        }
        count = Animation.readUnsignedShort(is);
        this.m_nFrames = new byte[count];
        this.m_actions = new short[count][];
        this.m_mechModels = new byte[count * 7];
        for (i = 0; i < count; ++i) {
            num = Animation.readUnsignedByte(is);
            int length = num * 2;
            this.m_nFrames[i] = (byte)num;
            this.m_actions[i] = new short[length];
            int index = i * 7;
            for (int k = 0; k < length; ++k) {
                this.m_actions[i][k] = (short)Animation.readUnsignedShort(is);
            }
            for (int j2 = 0; j2 < 7; ++j2) {
                this.m_mechModels[index + j2] = (byte)is.read();
            }
        }
    }

    public int getFrameID(int actionID, int frameSequenceID) {
        if (actionID < 0 || actionID >= this.m_nFrames.length) {
            return -1;
        }
        if (frameSequenceID < 0 || frameSequenceID >= this.m_nFrames[actionID]) {
            return -1;
        }
        return this.m_actions[actionID][frameSequenceID << 1] & 0xFFFF;
    }

    public int getLoopFrameID(int actionID, int frameSequenceID) {
        if (actionID < 0 || actionID >= this.m_nFrames.length) {
            return -1;
        }
        return this.m_actions[actionID][(frameSequenceID %= this.m_actions[actionID].length >> 1) << 1] & 0xFFFF;
    }

    public void draw(Graphics g, int screenX, int screenY, boolean flipX, boolean flipY, int frameIndex) {
        this.draw(g, screenX, screenY, flipX, flipY, frameIndex, this.m_visible, this.m_plteID);
    }

    public void draw(Graphics g, int screenX, int screenY, boolean flipX, boolean flipY, int frameIndex, boolean[] visible, String[] plteId) {
        short[] s = this.m_frames[frameIndex];
        for (int i = 0; i < s.length; i += 5) {
            int imgID = s[i] & 0xFFFF;
            if (imgID == -1 || !visible[imgID]) continue;
            int modID = (s[i + 1] & 0xFFFF) << 2;
            int flag = s[i + 2] & 0xFF;
            int modX = this.m_modules[imgID][modID] & 0xFFFF;
            int modY = this.m_modules[imgID][modID + 1] & 0xFFFF;
            int modW = this.m_modules[imgID][modID + 2] & 0xFFFF;
            int modH = this.m_modules[imgID][modID + 3] & 0xFFFF;
            int posX = screenX;
            int posY = screenY;
            if (flipX) {
                flag ^= 1;
                posX -= s[i + 3] + modW;
            } else {
                posX += s[i + 3];
            }
            if (flipY) {
                flag ^= 2;
                posY -= s[i + 4] + modH;
            } else {
                posY += s[i + 4];
            }
            Animation.drawRegion(posX, posY, modW, modH, modX, modY, Animation.getImage(this.m_imageID[imgID], plteId[imgID]), g, flag);
        }
    }

    public static int readUnsignedInt(InputStream is) {
        try {
            for (int i = 0; i < 4; ++i) {
                Animation.smallbuf[i] = (byte)is.read();
            }
            return Animation.readUnsignedInt(smallbuf, 0);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int readUnsignedShort(InputStream is) {
        try {
            for (int i = 0; i < 2; ++i) {
                Animation.smallbuf[i] = (byte)is.read();
            }
            return Animation.readUnsignedShort(smallbuf, 0);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int readUnsignedByte(InputStream is) {
        try {
            return is.read();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int readByte(byte[] b, int off) {
        if (off < 0 || off >= b.length) {
            return -1;
        }
        return b[off];
    }

    public static int readFully(InputStream is, byte[] array, int off, int len) {
        try {
            for (int i = 0; i < len; ++i) {
                array[off + i] = (byte)is.read();
            }
            return len;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int skipBytes(InputStream is, int n) {
        try {
            for (int i = 0; i < n; ++i) {
                is.read();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static final int readUnsignedShort(byte[] b, int off) {
        int res;
        if ((res = b[off++]) < 0) {
            res += 256;
        }
        res <<= 8;
        res += b[off];
        if (b[off] < 0) {
            res += 256;
        }
        return res;
    }

    public static final int readUnsignedInt(byte[] b, int off) {
        int res = 0;
        int i = 0;
        while (i < 4) {
            res <<= 8;
            res += b[off];
            if (b[off] < 0) {
                res += 256;
            }
            ++i;
            ++off;
        }
        return res;
    }

    public static int ReadInt(byte[] b, int off, int num) {
        int res = 0;
        for (int i = num - 1; i >= 0; --i) {
            res <<= 8;
            res += b[i + off];
            if (b[i + off] >= 0) continue;
            res += 256;
        }
        return res;
    }

    public static String readUTF(InputStream is) throws Exception {
        DataInputStream dis = new DataInputStream(is);
        return dis.readUTF();
    }

    public static void drawRegion(int dx, int dy, int w, int h, int sx, int sy, Image image, Graphics g, int manipulation) {
        if (w < 0 || h < 0) {
            return;
        }
        Animation.drawRegionNokia(dx, dy, w, h, sx, sy, image, g, manipulation);
    }

    public static void drawRegionNokia(int dx, int dy, int w, int h, int sx, int sy, Image image, Graphics g, int manipulation) {
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        width = w;
        height = h;
        x = sx;
        y = sy;
        switch (manipulation) {
            case 0: {
                break;
            }
            case 1: {
                manipulation = 8192;
                x = image.getWidth() - sx - w;
                break;
            }
            case 2: {
                manipulation = 16384;
                y = image.getHeight() - sy - h;
                break;
            }
            case 3: {
                manipulation = 180;
                x = image.getWidth() - sx - w;
                y = image.getHeight() - sy - h;
                break;
            }
            case 4: {
                width = h;
                height = w;
                manipulation = 270;
                x = image.getHeight() - sy - h;
                y = sx;
                break;
            }
            case 7: {
                width = h;
                height = w;
                manipulation = 90;
                x = sy;
                y = image.getWidth() - sx - w;
                break;
            }
            case 5: {
                width = h;
                height = w;
                x = sy;
                y = sx;
                manipulation = 16474;
                break;
            }
            case 6: {
                x = image.getHeight() - sy - h;
                y = image.getWidth() - sx - w;
                width = h;
                height = w;
                manipulation = 16654;
                break;
            }
        }
        g.setClip(dx, dy, width, height);
        if (manipulation == 0) {
            g.drawImage(image, dx - x, dy - y, 20);
        } else {
            dg.drawImage(image, dx - x, dy - y, 20, manipulation);
        }
    }

    public static void drawRegion(int dx, int dy, int w, int h, int sx, int sy, Image img, Graphics g) {
        g.setClip(dx, dy, w, h);
        g.drawImage(img, dx - sx, dy - sy, 20);
    }

    public int getImageCount() {
        return this.m_visible == null ? 0 : this.m_visible.length;
    }

    public static void clearAllImage() {
        m_images.clear();
        Enumeration enum1 = m_images.keys();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            Image image = (Image)m_images.get(key);
            image = null;
            m_images.put(key, null);
        }
    }

    public static void setImage(String path, String plte) {
        try {
            String key = path + plte;
            Image image = plte.equals("") ? Image.createImage((String)("/" + path)) : Main.loadImageFromAct(Main.defaultImagePath + path, Main.defaultImagePath + plte + ".plt");
            m_images.put(key, image);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Image getImage(String path, String plte) {
        String key = path + plte;
        Image image = (Image)m_images.get(key);
        if (image == null) {
            Animation.setImage(path, plte);
        }
        return (Image)m_images.get(key);
    }

    static {
        m_images = new Hashtable();
    }
}

